<?php
/*-----------------------------------------------------------------
* 	ID:						class.cachefiles.php
* 	Letzter Stand:			v2.2 R365
* 	zuletzt geaendert von:	akausch
* 	Datum:					2012/07/03
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/


class cacheFile {
	public $type;
	public $source = array();
	public $name;
	public $data;
	var $css = array();
	var $js = array();
	
	function __construct($type) {
		$this->type = $type;
	}
	
	function __destruct() {}
	
	public function setCSS($path) {
		$this->css[] = array('path' => $path);
	}
	
	public function setJS($path, $create_cache = 'true') {
		$this->js[] = array('path' => $path, 'file' => $create_cache);
	}
	
	public function outputCSS() {
		$css = '';
		$css_file = '';
		foreach($this->css AS $css_path) {
			$content ='';
			if(!file_exists($this->getCachePath($css_path['path'])) || (USE_TEMPLATE_CACHE == 'true' && filemtime($css_file) < time() - CACHE_TEMPLATE_LIFETIME)) {
				if(file_exists($css_path['path'])) {
					$content = $this->getCleanCSS(file_get_contents($css_path['path']));
					file_put_contents($this->getCachePath($css_path['path']), $content);
					$css .= $content;
				}
			} else
				$css .= file_get_contents($this->getCachePath($css_path['path']));
		}
		
		$css_file = '_css_'.$this->getTempName($this->css);


		if(!file_exists(DIR_FS_CATALOG.'cache/'.$css_file) || (USE_TEMPLATE_CACHE == 'true' && filemtime($css_file) < time() - CACHE_TEMPLATE_LIFETIME)) {

			@unlink($css_file);
			file_put_contents(DIR_FS_CATALOG.'cache/'.$css_file, $css);
		}
		return file_get_contents(DIR_FS_CATALOG.'cache/'.$css_file);
		
	}
	
	public function outputJS() {
		global $db, $price;
		$js = '';
		$js_file = '';
		foreach($this->js AS $js_path) {
			$content='';
			if($js_path['file'] == 'true') {
				if(!file_exists($this->getCachePath($js_path['path']))) {
					if(file_exists($js_path['path'])) {
						$content =  $this->getCleanJS(file_get_contents($js_path['path']));
						file_put_contents($this->getCachePath($js_path['path']), $content);
						$js .= $content;
					}
				} else
					$js .= file_get_contents($this->getCachePath($js_path['path']));

			} elseif($js_path['file'] == 'false') {
				include($js_path['path']);
				file_put_contents($this->getCachePath($js_path['path']), $content);
				$js .=  $this->getCleanJS($content);
			}	
		}
		
		$js_file = '_js_'.$this->getTempName($this->js);
		return $js;
	}
	
	public function getCachePath($path) {
		$real = pathinfo($path);
		if($this->type == 'css')
			return DIR_FS_CATALOG.'cache/_cache_css_'.$real['basename'];
		elseif($this->type == 'js')
			return DIR_FS_CATALOG.'cache/_cache_js_'.$real['basename'];
	}
	
	public function getCleanCSS($data) {
		$raw = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $data);
		$raw = preg_replace('/\s\s+/', ' ', $raw);
		
		$spaces = array('{ ', ' }', ' {', '} ', ' ,', ', ', ': ', ' :', '; ', ' ;');
		
		foreach($spaces AS $space)
			$raw = str_replace($space, trim($space), $raw);
		
		$content = str_replace(array("\r\n", "\r", "\n", "\t"), '', $raw);
		
		return $content;
	}
	
	function getCleanJS($data) {
		return $data = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $data);
	}
	
	function getTempName($path) {
		foreach($this->{$this->type} AS $name_path)
			$name .= $this->getCachePath($name_path['path']);
		return md5($name);
	}
}